local super = require "TableColumn"

CheckMarkColumn = super:new()

local defaults = {
}

local nilDefaults = {
    'value', 'paint',
}

local getterNames = {'value', 'paint'}

local inspectorInfo = {
    {'KeyArtifact', {'value'}, 'Value'},
    {'Color', {'getPaint:setPaint', custom = 'hasExplicitPaint:'}, 'Color'},
}

function CheckMarkColumn:new()
    self = super.new(self)
    
    for k, v in pairs(defaults) do
        self:addProperty(k, v)
    end
    for _, k in pairs(nilDefaults) do
        self:addProperty(k)
    end
    
    self.stamp = CheckMarkStamp
    self.getterNames = getterNames
    self.inspectorInfo = inspectorInfo
    
    return self
end

function CheckMarkColumn:unarchived()
    local dataset = self:getDataset()
    if dataset then
        if self:getProperty('value') == nil then
            local avoidingFields = self:peerPropertyKeyArtifactValues(CheckMarkColumn, 'value')
            local field = dataset:pickField('boolean', avoidingFields)
            if field then
                self:setProperty('value', KeyArtifact:new(field))
                self:setTitle(field)
            end
        end
    end
    super.unarchived(self)
end

function CheckMarkColumn:drawCell(canvas, rect, value, paint)
    CheckMarkStamp(canvas, rect, value, paint or self:getParent():getAccentPaint())
end

function CheckMarkColumn:getDefaultPaint()
    return self:getParent():getAccentPaint()
end

return CheckMarkColumn
